#ifndef _DRIVER_LESS_FRAMEWORK_
#define _DRIVER_LESS_FRAMEWORK_

typedef enum DEVICE_TYPE
{
    NONE=0,
    SUPERPRO = 1,
    EVE3 = 2,
    DUO = 4,
    LYNX64 = 8,
    LYNX128 = 16,
    LYNX256 = 32
} DEVICE_TYPE;

void DriverLessFrameworkInit();

// ALL keys must be assigned a client handle, use this API to iterate through the key list
// 32 keys are supported, we can expand this to 64 but that will leave us less room for 
// newer handle (ie: each insertion increment higher order by 1
IOReturn findNextUnit(UInt32* clientHandle, DEVICE_TYPE type);

// ALL SuperPro like keys (ie: Eve3, DUO, SuperPro, Lynx) will want to send and recieve 8 
// bytes of usb packet
IOReturn apiCommand(UInt32 clientHandle, UInt8* inUSBPacket, UInt8* outUSBPacket);

// This for keys that doesn't need to wait for send or receive packet (ie: iKey)
IOReturn sendPacket(UInt32 clientHandle, UInt8* inUSBPacket);
IOReturn receivePacket(UInt32 clientHandle, UInt8* outUSBPacket);

// we really don't need this; this is for backward issue                           
void getDriverVersion(UInt32 clientHandle, UInt8* pUSBPacket);
                             
#endif